clc
close all
clear all

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%    Plant  Parameters      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%mpt_init

global e1ac e2ac % Integral terms of the PI
global plant 

e1ac=0;
e2ac=0;

plant.g1=0.3;
plant.g2=0.4;

%Equilibrium levels

H1=0.6534;
H2=0.6521;
H3=0.6594; 
H4=0.6587;
plant.xl=[H1;H2;H3;H4];
plant.yl=plant.xl(1:2);

%Equilibrium Flows

Qa=3.26/2; %m^3/h
Qb=4/2;
plant.ul=[Qa;Qb];

plant.g=9.81; % Gravity

a1=(1/3600)*(plant.g1*Qa+(1-plant.g2)*Qb)/sqrt(2*plant.g*H1);
a2=(1/3600)*(plant.g2*Qb+(1-plant.g1)*Qa)/sqrt(2*plant.g*H2);
a3=(1/3600)*(1-plant.g2)*Qb/sqrt(2*plant.g*H3);
a4=(1/3600)*(1-plant.g1)*Qa/sqrt(2*plant.g*H4);

plant.a=[a1;a2;a3;a4];
plant.A=0.06; % m^2

plant.Tm=5;  %seg  Sample time

 

%plant.noise=5e-3;
plant.noise=0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     Initial levels        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% H10=plant.xl(1);
% H20=plant.xl(2);
% H30=plant.xl(3);
% H40=plant.xl(4);


plant.H10=0.5;
plant.H20=0.6;
plant.H30=0.7;
plant.H40=0.8;

%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     Levels Contraints   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%

plant.H1max=1.36;
plant.H1min=0.2;
plant.H2max=1.36;
plant.H2min=0.2;
plant.H3max=1.3;
plant.H3min=0.2;
plant.H4max=1.3;
plant.H4min=0.2;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%          Test           %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

esc=600;  %Samples of each reference 
stoptime= 4*esc*5;  %Total time


